% [name, price] = float_lookback(mu, sigma, up_weight, down_weight, up_exp,
% down_exp, up_freq,down_freq, lamda, H, S_initial) returns the price of 
% float_lookback call or put. Expiration data is assumed to have
% exp(lambda) distribution. If S_initial is smaller than H, it will be a
% put, whose payoff function is max(H,S_initial*exp(M(tau))-S(tau). 
% Otherwise, it will be a call, whose payoff function is
% S(tau)- min(H,S_initial*exp(m(tau)), where M(tau) and m(tau) denotes the
% max and min value of X(tau) between 0 and tau.  Name returns the name
% option, and it can be call or put.


function [name, price] = float_lookback(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, H, S_initial)

[alpha,beta] = return_alpha_beta(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);
[a_star, b_star] = return_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);
S_expect = stock_expect(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, S_initial);

if H <= S_initial
   name ='call';
    price = sum(a_star.* eta(alpha, H, S_initial)) - H + S_expect;
else
    name ='put';
    price = sum(b_star.* eta(beta, H, S_initial)) + H - S_expect;

end


function y = eta(h,K,S_initial)
y=S_initial.^h .* K.^(1-h)./(h.*(h-1)); 
