

% [name, price] = [name, price] = fractional_float_lookback(mu, sigma,
% up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda,
% gamma, S_initial) returns the price of fractional_float_lookback call or
% put. Expiration data is assumed to have exp(lambda) distribution. If gamma
% is between 0 and 1, it will be a put, whose payoff function is
% max(gamma*S_initial*exp(M(tau)-S(tau), 0). Otherwise, it will be a call,
% whose payoff function is max(S(tau)-gamma*S_initial*exp(m(tau), 0), where
% M(tau) and m(tau) denotes the max and min value of X(tau) between 0 and
% tau. Name returns the name option, and it can be call or put.  

function [name, price] = fractional_float_lookback(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, gamma, S_initial)

[alpha,beta] = return_alpha_beta(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);
[a_star, b_star] = return_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);
s = stock_expect(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, 1);
if length(alpha)==1 && length(beta)==1
    
    if gamma <= 1
        name = 'put';
        price = sum(a_star.* eta(alpha, S_initial*gamma, S_initial));
        price = price * (1-1/alpha)*s;
    else
        name = 'call';
        price = sum(b_star.* eta(beta, S_initial*gamma, S_initial));
        price = price * (1-1/beta)*s;
    end
    
else
    if gamma <= 1
        name = 'put';
        price = sum(a_star.* eta(alpha, S_initial*gamma, S_initial));
        price = price * prod((up_exp - 1) ./ up_exp) * prod (beta ./(beta - 1));
    else
        name = 'call';
        price = sum(b_star.* eta(beta, S_initial*gamma, S_initial));
        price = price * prod((down_exp + 1) ./ down_exp) * prod( -alpha ./ (1- alpha));
    end
end


function y = eta(h,K,S_initial)
y=S_initial.^h .* K.^(1-h)./(h.*(h-1));