% [put, call] = knock_in(mu, sigma, up_weight, down_weight, up_exp,
% down_exp, up_freq,down_freq, lambda, K,  L, S_initial) returns the price 
% of knock_in call and put. Expiration data is assumed to have exp(lambda)
% distribution.If S_initial is smaller than L, it should be a up and in
% option, whose payoff function is I[S_initial*exp(M(tau)>L]*b(S(tau),
% where I[] is an indicator function and b() is a payoff function of call
% or put. Otherwise, it will be a down and in option, whose payoff function
% is I[S_initial*exp(m(tau)<L]*b(S(tau).M(tau) and m(tau) denotes the max
% and min value of X(tau) between 0 and tau. 

function [put, call] = knock_in(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, K,  L, S_initial)

[alpha,beta] = return_alpha_beta(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);
[a_star, b_star] = return_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);
[a,b] =  return_no_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq,lambda0);
m = length(a);
n = length(b);
sum1 = 0;
sum2 = 0;

if S_initial <= L   
    for j = 1:m
        for k = 1:n
            sum1 = sum1 + a_star(j) * b_star(k) / (beta(k) - alpha(j)) * (S_initial / L) ^ beta(k) * Lambda_alpha_call(alpha(j),K,L);
            sum2 = sum2 + a_star(j) * b_star(k) / (beta(k) - alpha(j)) * (S_initial / L) ^ beta(k) * Lambda_alpha_put(alpha(j),K,L);
        end
    end
    
    put = sum2 + sum((S_initial/L).^ beta .* b .* Lambda_beta_put(beta,K,L));
    call = sum1 + sum((S_initial/L).^ beta .* b .* Lambda_beta_call(beta,K,L));

else
    for j = 1:m
        for k = 1:n
            sum1 = sum1 + a_star(j) * b_star(k) / (beta(k) - alpha(j)) * (S_initial / L) ^ alpha(j) * Lambda_beta_call(beta(k),K,L);
            sum2 = sum2 + a_star(j) * b_star(k) / (beta(k) - alpha(j)) * (S_initial / L) ^ alpha(j) * Lambda_beta_put(beta(k),K,L);
        end
    end
    
    put = sum2 + sum((S_initial/L).^ alpha .* a .* Lambda_alpha_put(alpha,K,L));
    call = sum1 + sum((S_initial/L).^ alpha .* a .* Lambda_alpha_call(alpha,K,L));
end  
    


function y = Lambda_alpha_call(alpha,K,L)
    
if L < K
    y = 0;
else
    y = L.^ alpha .* K .^(1-alpha)./(alpha.*(alpha-1))+(L ./ (-alpha+1) - K ./ (-alpha));
end
    

function y = Lambda_beta_call(beta,K,L)

if L < K
    y = L.^ beta .* K.^(1-beta)./(beta.*(beta-1));
else
    y = L./(beta-1) - K./(beta);
end


function y =  Lambda_beta_put(beta,K,L)
if L > K
    y = 0;
else
    y = L.^ beta .* K.^(1-beta)./(beta.*(beta-1))-(L./(beta-1) - K ./ beta);
end   
    

function y = Lambda_alpha_put(alpha,K,L)
if L < K
    y = K ./ -alpha - L ./ (-alpha+1);
else
    
    y = L.^ alpha .* K.^(1-alpha)./(alpha .* (alpha-1));
end 