function [name, price] = life_fractional_float_lookback(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda, gamma, S_initial, linear_coeff, interest_rate)

n = length(lambda);
price_vector  = zeros(1,n);
for i=1:n
    [name, price_m] = fractional_float_lookback(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda(i)+interest_rate, gamma, S_initial);
    
    price_vector(i)= price_m * lambda(i)/(lambda(i)+interest_rate);
end

    price = sum(price_vector .* linear_coeff);
end