
% [a,b] =  return_no_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq,lambda)  
% returns the coefficient of density function of X(tau).

function [a,b] =  return_no_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq,lambda) 
            [a_star,b_star] = return_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda);
            [alpha,beta] = return_alpha_beta(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda);
            n = length(alpha);
            b = zeros(1,n);
            a = zeros(1,n);
            if length(alpha)==1 && length(beta)==1
                a = lambda/(0.5* sigma^2)/(beta-alpha);
                b = lambda/(0.5* sigma^2)/(beta-alpha);
            else
            for i=1:n
                b(i)= prod((down_exp + beta(i)) ./ down_exp) * prod( -alpha ./ (beta(i)- alpha)) * b_star(i);
                a(i)= prod((up_exp - alpha(i)) ./ up_exp) * prod (beta ./(beta - alpha(i))) * a_star(i);
            end
            a = a';
            b = b';
            end
            


