% [a_star,b_star] = return_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda) 
% returns the coefficient of density function of m(tau) and M(tau).

function [a_star,b_star] = return_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda) 
[alpha,beta] = return_alpha_beta(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda);
n = length(alpha);
b_star = zeros(1,n);
a_star = zeros(1,n);
if length(alpha)==1 && length(beta)==1
    b_star = beta;
    a_star = -alpha;
else
for i=1:n
   beta_new = beta(transpose(find(beta ~= beta(i))));
   alpha_new = alpha(transpose(find(alpha ~=alpha(i))));
   b_star(i)= prod((up_exp - beta(i)) ./ up_exp) * prod (beta_new ./(beta_new - beta(i))) * beta(i);
   a_star(i)= prod((down_exp + alpha(i)) ./ down_exp) * prod( -alpha_new ./ (alpha(i)- alpha_new)) * -alpha(i);
end
a_star = a_star';
b_star = b_star';

end




