
% Assuming interest rate is zero, stock_expect(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda, S_initial)
% returns the expected value of stock price in Jump diffusion model, where expiration data is assumed to
% have exp(lambda) distribution.  

function s = stock_expect(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, S_initial)

s = S_initial .* lambda0 ./ (lambda0 - phi(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq,1));


