% [put, call]= call_put(mu, sigma, up_weight, down_weight, up_exp,
% down_exp, up_freq,down_freq, lambda, K, S_initial) returns the price of call and
% put option in Jump diffustion model, where expiration data is assumed to
% have exp(lambda) distribution. 

function [put, call]= vanilla(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, K, S_initial)
[alpha,beta] = return_alpha_beta(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0);
[a,b] =  return_no_star(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq,lambda0);
S_expect = stock_expect(mu, sigma, up_weight, down_weight, up_exp, down_exp, up_freq,down_freq, lambda0, S_initial);

if K <= S_initial
    put = sum(a.* eta(alpha,K,S_initial));
    call = sum(a.* eta(alpha,K,S_initial)) - K + S_expect;
else
    call = sum(b.* eta(beta, K, S_initial));
    put = sum(b.* eta(beta, K, S_initial)) + K - S_expect;

end


function y = eta(h,K,S_initial)
y=S_initial.^h .* K.^(1-h)./(h.*(h-1)); 




